/*SOLO CON CREATE PORQUE ES PARA IMPLEMENTAR*/
CREATE PROCEDURE [dbo].[CPUJ_CD_Lista_Blanca] @pJson VARCHAR(8000)
AS
SET NOCOUNT ON


/*Variables recibidas por parametro a traves del JSON*/
DECLARE @pModoDebug				TINYINT
DECLARE @pId_Usuario			SMALLINT
DECLARE @pId_Acceso				SMALLINT
DECLARE @pFecha_Evento			DATETIME

SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Usuario				= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Usuario')), 0)
SET @pId_Acceso					= ISNULL(CONVERT(SMALLINT, dbo.CF_JSON_VALUE(@pJson,'Id_Acceso')), 0)
SET @pFecha_Evento				= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha_Evento')), '19000101')
/*FIN Variables recibidas por parametro a traves del JSON*/

/*Variable de Retorno del Stored*/
DECLARE @rtaMsjStored			VARCHAR(4000)
/*FIN Variable de Retorono del Stored*/

/*Declaracion de Variables*/
DECLARE @Fecha_Proceso		DATETIME
DECLARE @Cantidad_Registros INT
/*FIN Declaracion de Variables*/


BEGIN TRY
	
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPUJ_CD_Lista_Blanca'
		PRINT 'Parametros:'
		PRINT '@pModoDebug: ' + CONVERT(VARCHAR(10), @pModoDebug) + '. @pId_Acceso: ' + CONVERT(VARCHAR(10), @pId_Acceso) + '. @pFecha_Evento: ' + CONVERT(VARCHAR(10), @pFecha_Evento, 102)
	END

	IF(@pId_Usuario = 0)
	BEGIN
		SET @pId_Usuario = -1
	END

	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------

	SET @Fecha_Proceso = GETDATE()

	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------

	IF OBJECT_ID('tempdb..#Clientes_Lista_Blanca', 'U') IS NOT NULL
	BEGIN
		DROP TABLE #Clientes_Lista_Blanca
	END

	CREATE TABLE #Clientes_Lista_Blanca
	(Id_Cliente	INT,
	Mensaje		VARCHAR(5000))

	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------

	--IMPLEMENTAR
	--A continuacion lo comentado es un implentacion de EJEMPLO

	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------

	--Por Master
	INSERT INTO #Clientes_Lista_Blanca
	SELECT DISTINCT Id_Cliente, 'Acceso Master'
	FROM CD_Cli_Master

	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------

	--Por Producto
	INSERT INTO #Clientes_Lista_Blanca
	SELECT DISTINCT CI.Id_Cliente, 'Habilit. por Produc. Comprado: ' + LTRIM(RTRIM(ISNULL(PR.Descripcion_Resumida, PR.Id_Producto)))
	FROM Cbtes CB, Cbtes_Items CI, Cbtes_Tipos CT, Clientes CL, Productos PR
	WHERE
	CB.Id_Trans = CI.Id_Trans
	AND CB.Id_Tipo_Cbte = CT.Id_Tipo_Cbte
	AND CI.Id_Producto = PR.Id_Producto
	AND CI.Id_Cliente = CL.Id_Cliente
	AND CI.Id_Producto IN (SELECT Id_Producto FROM CD_Accesos_Prod WHERE Id_Acceso = @pId_Acceso)
	AND (	(CT.Compromete_Factura = 1 AND CB.Id_Estado_Cbte IN (4, 2))
			OR (CT.Compromete_Factura = 1 AND CB.Id_Estado_Cbte IN (1) AND CI.Imp_Final = 0)
			OR (CT.Compromete_Pedido = 1 AND CB.Id_Estado_Cbte IN (1,2,4))
		)
	AND CONVERT(DATE, CI.Fecha_QA) <= CONVERT(DATE, @pFecha_Evento)
	AND CONVERT(DATE, CI.Fecha_Venc) >= CONVERT(DATE, @pFecha_Evento)

	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------

	--Por Categoria
	INSERT INTO #Clientes_Lista_Blanca
	SELECT DISTINCT CL.Id_Cliente, 'Habilit. por Tipo de Cliente: ' + LTRIM(RTRIM(CONVERT(VARCHAR(10), CT.Descripcion)))
	FROM Clientes CL, Clientes_Tipos CT
	WHERE
	CL.Id_Tipo_Cli = CT.Id_Tipo_Cli
	AND CL.Activo = 1
	AND CL.Id_Tipo_Cli IN (SELECT Id_Tipo_Cli FROM CD_Accesos_Cli_Tipos WHERE Id_Acceso = @pId_Acceso)

	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------

	--Por Contrato Habilitante
	INSERT INTO #Clientes_Lista_Blanca
	SELECT DISTINCT CL.Id_Cliente, 'Habilit. por Tipo de Contrato: ' + RTRIM(LTRIM(CT.Descripcion))
	FROM Clientes CL, Contratos CO, Contratos_Tipos CT
	WHERE
	CL.Id_Cliente = CO.Id_Cliente
	AND CO.Id_Tipo_Con = CT.Id_Tipo_Con
	AND CL.Activo = 1
	AND CO.Activo = 1
	AND CO.Id_Tipo_Con IN (SELECT Id_Tipo_Con FROM CD_Accesos_Cont_Tipos WHERE ISNULL(Flag_Habilitado, 'H') = 'H' AND Id_Acceso = @pId_Acceso)
	AND CONVERT(DATE, Fecha_Desde) <= CONVERT(DATE, @pFecha_Evento)
	AND (CONVERT(DATE, Fecha_Hasta) >= @pFecha_Evento OR Fecha_Hasta IS NULL)

	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------

	--Por Contrato Rechazo
	DELETE FROM #Clientes_Lista_Blanca
	WHERE
	Id_Cliente IN (	SELECT DISTINCT CL.Id_Cliente
					FROM Clientes CL, Contratos CO
					WHERE
					CL.Id_Cliente = CO.Id_Cliente
					AND CL.Activo = 1
					AND CO.Activo = 1
					AND CO.Id_Tipo_Con IN (SELECT Id_Tipo_Con FROM CD_Accesos_Cont_Tipos WHERE ISNULL(Flag_Habilitado, 'H') = 'R' AND Id_Acceso = @pId_Acceso)
					AND CONVERT(DATE, Fecha_Desde) <= CONVERT(DATE, @pFecha_Evento)
					AND (CONVERT(DATE, Fecha_Hasta) >= CONVERT(DATE, @pFecha_Evento) OR Fecha_Hasta IS NULL))

	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------

	IF OBJECT_ID('tempdb..#CD_Lista_Blanca_Con_Repetidos', 'U') IS NOT NULL
	BEGIN
		DROP TABLE #CD_Lista_Blanca_Con_Repetidos
	END

	CREATE TABLE #CD_Lista_Blanca_Con_Repetidos
	(Id_Acceso				SMALLINT,
	Fecha_Proceso			DATETIME,
	Id_Formato				CHAR(1),
	Id_Cliente				INT,
	Razon_Social			VARCHAR(100),
	Credencial_Nro			VARCHAR(30),
	Credencial_Nro_Intelek	VARCHAR(30),
	Mensaje					VARCHAR(5000),
	Doc_Nro					BIGINT)

	INSERT INTO #CD_Lista_Blanca_Con_Repetidos
	SELECT 
	DISTINCT
	@pId_Acceso												AS Id_Acceso,
	@Fecha_Proceso											AS Fecha_Proceso,
	'I'														AS Formato,
	CL.Id_Cliente											AS Id_Cliente,
	LTRIM(RTRIM(CL.Razon_Social))							AS Razon_Social,
	LTRIM(RTRIM(ISNULL(CL.Credencial_Nro, '')))				AS Credencial_Nro,
	dbo.CF_Credencial_Nro_Format_Itelek(CL.Credencial_Nro)	AS Credencial_Nro_Intelek,
	z.Mensaje												AS Mensaje,
	ISNULL(CL.Doc_Nro, 0)									AS Doc_Nro
	FROM #Clientes_Lista_Blanca Z, Clientes CL
	WHERE
	Z.Id_Cliente = CL.Id_Cliente;

	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------

	WITH
	Filas_Repetidas AS
	(
		SELECT
		ROW_NUMBER() OVER (PARTITION BY Id_Cliente ORDER BY Id_Cliente) AS Fila
		,*
		FROM #CD_Lista_Blanca_Con_Repetidos a
		WHERE a.Id_Cliente  IN (SELECT DISTINCT Id_Cliente FROM #CD_Lista_Blanca_Con_Repetidos)
	)
	DELETE FROM Filas_Repetidas WHERE Fila > 1;

	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------

	DELETE FROM CD_Lista_Blanca WHERE Id_Acceso = @pId_Acceso

	INSERT INTO CD_Lista_Blanca
	(Id_Acceso, Fecha_Proceso, Id_Formato, Id_Cliente, Razon_Social, Credencial_Nro, Credencial_Nro_Intelek, Mensaje, Doc_Nro)
	SELECT * FROM #CD_Lista_Blanca_Con_Repetidos

	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------
	-----------------------------------------------------------------------------------------------------------------------------------------------------------

	SET @Cantidad_Registros = (SELECT COUNT(*) FROM CD_Lista_Blanca WHERE Id_Acceso = @pId_Acceso)

	SET @rtaMsjStored		= 'Cant. Registros: ' + CONVERT(VARCHAR(10), @Cantidad_Registros)

	SELECT	 0				AS ErrorNumber 
			,0				AS ErrorSeverity  
			,0				AS ErrorState 
			,0				AS ErrorProcedure  
			,0				AS ErrorLine		
			,@rtaMsjStored	AS ErrorMessage

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPUJ_CD_Lista_Blanca'
	END

END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	RETURN 9999
END CATCH

RETURN 0

--EXEC dbo.CPUJ_CD_Lista_Blanca '{"ModoDebug":"1","Id_Acceso":"2","Fecha_Evento":"2021-10-25T19:00:00"}'